WebInspector.SecurityModel=function(target)
{WebInspector.SDKModel.call(this,WebInspector.SecurityModel,target);this._dispatcher=new WebInspector.SecurityDispatcher(this);this._securityAgent=target.securityAgent();target.registerSecurityDispatcher(this._dispatcher);this._securityAgent.enable();}
WebInspector.SecurityModel.EventTypes={SecurityStateChanged:"SecurityStateChanged"}
WebInspector.SecurityModel.prototype={__proto__:WebInspector.SDKModel.prototype}
WebInspector.SecurityModel.fromTarget=function(target)
{var model=(target.model(WebInspector.SecurityModel));if(!model)
model=new WebInspector.SecurityModel(target);return model;}
WebInspector.SecurityModel.SecurityStateComparator=function(a,b)
{var securityStateMap;if(WebInspector.SecurityModel._symbolicToNumericSecurityState){securityStateMap=WebInspector.SecurityModel._symbolicToNumericSecurityState;}else{securityStateMap=new Map();var ordering=[SecurityAgent.SecurityState.Unknown,SecurityAgent.SecurityState.Info,SecurityAgent.SecurityState.Insecure,SecurityAgent.SecurityState.Neutral,SecurityAgent.SecurityState.Warning,SecurityAgent.SecurityState.Secure];for(var i=0;i<ordering.length;i++)
securityStateMap.set(ordering[i],i+1);WebInspector.SecurityModel._symbolicToNumericSecurityState=securityStateMap;}
var aScore=securityStateMap.get(a)||0;var bScore=securityStateMap.get(b)||0;return aScore-bScore;}
WebInspector.PageSecurityState=function(securityState,explanations,mixedContentStatus,schemeIsCryptographic){this.securityState=securityState;this.explanations=explanations;this.mixedContentStatus=mixedContentStatus;this.schemeIsCryptographic=schemeIsCryptographic;}
WebInspector.SecurityDispatcher=function(model)
{this._model=model;}
WebInspector.SecurityDispatcher.prototype={securityStateChanged:function(securityState,explanations,mixedContentStatus,schemeIsCryptographic)
{var pageSecurityState=new WebInspector.PageSecurityState(securityState,explanations||[],mixedContentStatus||null,schemeIsCryptographic||false);this._model.dispatchEventToListeners(WebInspector.SecurityModel.EventTypes.SecurityStateChanged,pageSecurityState);}};WebInspector.SecurityPanel=function()
{WebInspector.PanelWithSidebar.call(this,"security");var sidebarTree=new TreeOutlineInShadow();sidebarTree.element.classList.add("sidebar-tree");this.panelSidebarElement().appendChild(sidebarTree.element);sidebarTree.registerRequiredCSS("security/sidebar.css");sidebarTree.registerRequiredCSS("security/lockIcon.css");this.setDefaultFocusedElement(sidebarTree.element);this._sidebarMainViewElement=new WebInspector.SecurityMainViewSidebarTreeElement(this);sidebarTree.appendChild(this._sidebarMainViewElement);this._sidebarOriginSection=new WebInspector.SidebarSectionTreeElement(WebInspector.UIString("Origins"));this._sidebarOriginSection.listItemElement.classList.add("security-sidebar-origins");sidebarTree.appendChild(this._sidebarOriginSection);this._mainView=new WebInspector.SecurityMainView(this);this._lastResponseReceivedForLoaderId=new Map();this._origins=new Map();WebInspector.targetManager.addModelListener(WebInspector.ResourceTreeModel,WebInspector.ResourceTreeModel.EventTypes.MainFrameNavigated,this._onMainFrameNavigated,this);this._filterRequestCounts=new Map();WebInspector.targetManager.observeTargets(this,WebInspector.Target.Type.Page);WebInspector.targetManager.addModelListener(WebInspector.NetworkManager,WebInspector.NetworkManager.EventTypes.ResponseReceived,this._onResponseReceived,this);WebInspector.targetManager.addModelListener(WebInspector.NetworkManager,WebInspector.NetworkManager.EventTypes.RequestFinished,this._onRequestFinished,this);WebInspector.targetManager.addModelListener(WebInspector.SecurityModel,WebInspector.SecurityModel.EventTypes.SecurityStateChanged,this._onSecurityStateChanged,this);}
WebInspector.SecurityPanel.Origin;WebInspector.SecurityPanel.OriginState;WebInspector.SecurityPanel.prototype={setRanInsecureContentStyle:function(securityState)
{this._ranInsecureContentStyle=securityState;},setDisplayedInsecureContentStyle:function(securityState)
{this._displayedInsecureContentStyle=securityState;},_updateSecurityState:function(newSecurityState,explanations,mixedContentStatus,schemeIsCryptographic)
{this._sidebarMainViewElement.setSecurityState(newSecurityState);this._mainView.updateSecurityState(newSecurityState,explanations,mixedContentStatus,schemeIsCryptographic);},_onSecurityStateChanged:function(event)
{var data=(event.data);var securityState=(data.securityState);var explanations=(data.explanations);var mixedContentStatus=(data.mixedContentStatus);var schemeIsCryptographic=(data.schemeIsCryptographic);this._updateSecurityState(securityState,explanations,mixedContentStatus,schemeIsCryptographic);},showMainView:function()
{this._setVisibleView(this._mainView);},showOrigin:function(origin)
{var originState=this._origins.get(origin);if(!originState.originView)
originState.originView=new WebInspector.SecurityOriginView(this,origin,originState);this._setVisibleView(originState.originView);},wasShown:function()
{WebInspector.Panel.prototype.wasShown.call(this);if(!this._visibleView)
this._sidebarMainViewElement.select();},_setVisibleView:function(view)
{if(this._visibleView===view)
return;if(this._visibleView)
this._visibleView.detach();this._visibleView=view;if(view)
this.splitWidget().setMainWidget(view);},_onResponseReceived:function(event)
{var request=(event.data);if(request.resourceType()==WebInspector.resourceTypes.Document)
this._lastResponseReceivedForLoaderId.set(request.loaderId,request);},_processRequest:function(request)
{var origin=WebInspector.ParsedURL.splitURLIntoPathComponents(request.url)[0];if(!origin){return;}
var securityState=(request.securityState());if(request.mixedContentType===NetworkAgent.RequestMixedContentType.Blockable&&this._ranInsecureContentStyle)
securityState=this._ranInsecureContentStyle;else if(request.mixedContentType===NetworkAgent.RequestMixedContentType.OptionallyBlockable&&this._displayedInsecureContentStyle)
securityState=this._displayedInsecureContentStyle;if(this._origins.has(origin)){var originState=this._origins.get(origin);var oldSecurityState=originState.securityState;originState.securityState=this._securityStateMin(oldSecurityState,securityState);if(oldSecurityState!=originState.securityState){this._sidebarOriginSection.removeChild(originState.sidebarElement);this._insertOriginViewSidebarTreeElementSorted(originState.sidebarElement,securityState);if(originState.originView)
originState.originView.setSecurityState(securityState);}}else{var originState={};originState.securityState=securityState;var securityDetails=request.securityDetails();if(securityDetails){originState.securityDetails=securityDetails;originState.certificateDetailsPromise=request.target().networkManager.certificateDetailsPromise(securityDetails.certificateId);}
this._origins.set(origin,originState);originState.sidebarElement=new WebInspector.SecurityOriginViewSidebarTreeElement(this,origin);this._insertOriginViewSidebarTreeElementSorted(originState.sidebarElement,securityState);}},_insertOriginViewSidebarTreeElementSorted:function(sidebarElement,securityState)
{sidebarElement.setSecurityState(securityState);var originSectionChildList=(this._sidebarOriginSection.children());this._sidebarOriginSection.insertChild(sidebarElement,originSectionChildList.upperBound(sidebarElement,WebInspector.SecurityOriginViewSidebarTreeElement.SecurityStateComparator));},_onRequestFinished:function(event)
{var request=(event.data);this._updateFilterRequestCounts(request);this._processRequest(request);},_updateFilterRequestCounts:function(request)
{if(request.mixedContentType===NetworkAgent.RequestMixedContentType.None)
return;var filterKey=WebInspector.NetworkLogView.MixedContentFilterValues.All;if(request.wasBlocked())
filterKey=WebInspector.NetworkLogView.MixedContentFilterValues.Blocked;else if(request.mixedContentType===NetworkAgent.RequestMixedContentType.Blockable)
filterKey=WebInspector.NetworkLogView.MixedContentFilterValues.BlockOverridden;else if(request.mixedContentType===NetworkAgent.RequestMixedContentType.OptionallyBlockable)
filterKey=WebInspector.NetworkLogView.MixedContentFilterValues.Displayed;if(!this._filterRequestCounts.has(filterKey))
this._filterRequestCounts.set(filterKey,1);else
this._filterRequestCounts.set(filterKey,this._filterRequestCounts.get(filterKey)+1);this._mainView.refreshExplanations();},filterRequestCount:function(filterKey)
{return this._filterRequestCounts.get(filterKey)||0;},_securityStateMin:function(stateA,stateB)
{return WebInspector.SecurityModel.SecurityStateComparator(stateA,stateB)<0?stateA:stateB;},targetAdded:function(target)
{WebInspector.SecurityModel.fromTarget(target);},targetRemoved:function(target)
{},_clearOrigins:function()
{this._sidebarMainViewElement.select();this._sidebarOriginSection.removeChildren();this._origins.clear();this._lastResponseReceivedForLoaderId.clear();this._filterRequestCounts.clear();},_onMainFrameNavigated:function(event){var frame=(event.data);var request=this._lastResponseReceivedForLoaderId.get(frame.loaderId);this._clearOrigins();if(request)
this._processRequest(request);},__proto__:WebInspector.PanelWithSidebar.prototype}
WebInspector.SecurityPanel._instance=function()
{if(!WebInspector.SecurityPanel._instanceObject)
WebInspector.SecurityPanel._instanceObject=new WebInspector.SecurityPanel();return WebInspector.SecurityPanel._instanceObject;}
WebInspector.SecurityPanel.createCertificateViewerButton=function(text,certificateId)
{function showCertificateViewer(e)
{e.consume();WebInspector.multitargetNetworkManager.showCertificateViewer((certificateId));}
return createTextButton(text,showCertificateViewer,"security-certificate-button");}
WebInspector.SecurityMainViewSidebarTreeElement=function(panel)
{this._panel=panel;WebInspector.SidebarTreeElement.call(this,"security-main-view-sidebar-tree-item",WebInspector.UIString("Overview"));this.iconElement.classList.add("lock-icon");}
WebInspector.SecurityMainViewSidebarTreeElement.prototype={onattach:function()
{WebInspector.SidebarTreeElement.prototype.onattach.call(this);},setSecurityState:function(newSecurityState)
{for(var className of Array.prototype.slice.call(this.iconElement.classList)){if(className.startsWith("lock-icon-"))
this.iconElement.classList.remove(className);}
this.iconElement.classList.add("lock-icon-"+newSecurityState);},onselect:function()
{this._panel.showMainView();return true;},__proto__:WebInspector.SidebarTreeElement.prototype}
WebInspector.SecurityOriginViewSidebarTreeElement=function(panel,origin)
{this._panel=panel;this._origin=origin;this._securityState=SecurityAgent.SecurityState.Unknown;this.small=true;WebInspector.SidebarTreeElement.call(this,"security-sidebar-tree-item",origin);this.iconElement.classList.add("security-property");}
WebInspector.SecurityOriginViewSidebarTreeElement.prototype={onselect:function()
{this._panel.showOrigin(this._origin);return true;},setSecurityState:function(newSecurityState)
{if(this._securityState)
this.iconElement.classList.remove("security-property-"+this._securityState)
this._securityState=newSecurityState;this.iconElement.classList.add("security-property-"+newSecurityState);},securityState:function()
{return this._securityState;},__proto__:WebInspector.SidebarTreeElement.prototype}
WebInspector.SecurityOriginViewSidebarTreeElement.SecurityStateComparator=function(a,b)
{return WebInspector.SecurityModel.SecurityStateComparator(a.securityState(),b.securityState());}
WebInspector.SecurityPanelFactory=function()
{}
WebInspector.SecurityPanelFactory.prototype={createPanel:function()
{return WebInspector.SecurityPanel._instance();}}
WebInspector.SecurityMainView=function(panel)
{WebInspector.VBox.call(this,true);this.registerRequiredCSS("security/mainView.css");this.registerRequiredCSS("security/lockIcon.css");this.setMinimumSize(200,100);this.contentElement.classList.add("security-main-view");this._panel=panel;this._summarySection=this.contentElement.createChild("div","security-summary");this._securityExplanations=this.contentElement.createChild("div","security-explanation-list");this._summarySection.createChild("div","security-summary-section-title").textContent=WebInspector.UIString("Security Overview");var lockSpectrum=this._summarySection.createChild("div","lock-spectrum");lockSpectrum.createChild("div","lock-icon lock-icon-secure").title=WebInspector.UIString("Secure");lockSpectrum.createChild("div","security-summary-lock-spacer");lockSpectrum.createChild("div","lock-icon lock-icon-neutral").title=WebInspector.UIString("Not Secure");lockSpectrum.createChild("div","security-summary-lock-spacer");lockSpectrum.createChild("div","lock-icon lock-icon-insecure").title=WebInspector.UIString("Insecure (Broken)");this._summarySection.createChild("div","triangle-pointer-container").createChild("div","triangle-pointer-wrapper").createChild("div","triangle-pointer");this._summaryText=this._summarySection.createChild("div","security-summary-text");}
WebInspector.SecurityMainView.prototype={_addExplanation:function(explanation)
{var explanationSection=this._securityExplanations.createChild("div","security-explanation");explanationSection.classList.add("security-explanation-"+explanation.securityState);explanationSection.createChild("div","security-property").classList.add("security-property-"+explanation.securityState);var text=explanationSection.createChild("div","security-explanation-text");text.createChild("div","security-explanation-title").textContent=explanation.summary;text.createChild("div").textContent=explanation.description;if(explanation.certificateId){text.appendChild(WebInspector.SecurityPanel.createCertificateViewerButton(WebInspector.UIString("View certificate"),explanation.certificateId));}
return text;},updateSecurityState:function(newSecurityState,explanations,mixedContentStatus,schemeIsCryptographic)
{this._summarySection.classList.remove("security-summary-"+this._securityState);this._securityState=newSecurityState;this._summarySection.classList.add("security-summary-"+this._securityState);var summaryExplanationStrings={"unknown":WebInspector.UIString("This security of this page is unknown."),"insecure":WebInspector.UIString("This page is insecure (broken HTTPS)."),"neutral":WebInspector.UIString("This page is not secure."),"secure":WebInspector.UIString("This page is secure (valid HTTPS).")}
this._summaryText.textContent=summaryExplanationStrings[this._securityState];this._explanations=explanations,this._mixedContentStatus=mixedContentStatus;this._schemeIsCryptographic=schemeIsCryptographic;this._panel.setRanInsecureContentStyle(mixedContentStatus.ranInsecureContentStyle);this._panel.setDisplayedInsecureContentStyle(mixedContentStatus.displayedInsecureContentStyle);this.refreshExplanations();},refreshExplanations:function()
{this._securityExplanations.removeChildren();for(var explanation of this._explanations)
this._addExplanation(explanation);this._addMixedContentExplanations();},_addMixedContentExplanations:function()
{if(!this._schemeIsCryptographic)
return;if(this._mixedContentStatus&&(this._mixedContentStatus.ranInsecureContent||this._mixedContentStatus.displayedInsecureContent)){if(this._mixedContentStatus.ranInsecureContent)
this._addMixedContentExplanation(this._mixedContentStatus.ranInsecureContentStyle,WebInspector.UIString("Active Mixed Content"),WebInspector.UIString("You have recently allowed insecure content (such as scripts or iframes) to run on this site."),WebInspector.NetworkLogView.MixedContentFilterValues.BlockOverridden,showBlockOverriddenMixedContentInNetworkPanel);if(this._mixedContentStatus.displayedInsecureContent)
this._addMixedContentExplanation(this._mixedContentStatus.displayedInsecureContentStyle,WebInspector.UIString("Mixed Content"),WebInspector.UIString("The site includes HTTP resources."),WebInspector.NetworkLogView.MixedContentFilterValues.Displayed,showDisplayedMixedContentInNetworkPanel);}
if(this._mixedContentStatus&&(!this._mixedContentStatus.displayedInsecureContent&&!this._mixedContentStatus.ranInsecureContent)){this._addExplanation(({"securityState":SecurityAgent.SecurityState.Secure,"summary":WebInspector.UIString("Secure Resources"),"description":WebInspector.UIString("All resources on this page are served securely.")}));}
if(this._panel.filterRequestCount(WebInspector.NetworkLogView.MixedContentFilterValues.Blocked)>0)
this._addMixedContentExplanation(SecurityAgent.SecurityState.Info,WebInspector.UIString("Blocked mixed content"),WebInspector.UIString("Your page requested insecure resources that were blocked."),WebInspector.NetworkLogView.MixedContentFilterValues.Blocked,showBlockedMixedContentInNetworkPanel);function showDisplayedMixedContentInNetworkPanel(e)
{e.consume();WebInspector.NetworkPanel.revealAndFilter(WebInspector.NetworkLogView.FilterType.MixedContent,WebInspector.NetworkLogView.MixedContentFilterValues.Displayed);}
function showBlockOverriddenMixedContentInNetworkPanel(e)
{e.consume();WebInspector.NetworkPanel.revealAndFilter(WebInspector.NetworkLogView.FilterType.MixedContent,WebInspector.NetworkLogView.MixedContentFilterValues.BlockOverridden);}
function showBlockedMixedContentInNetworkPanel(e)
{e.consume();WebInspector.NetworkPanel.revealAndFilter(WebInspector.NetworkLogView.FilterType.MixedContent,WebInspector.NetworkLogView.MixedContentFilterValues.Blocked);}},_addMixedContentExplanation:function(securityState,summary,description,filterKey,networkFilterFn)
{var mixedContentExplanation=({"securityState":securityState,"summary":summary,"description":description});var filterRequestCount=this._panel.filterRequestCount(filterKey);var requestsAnchor=this._addExplanation(mixedContentExplanation).createChild("div","security-mixed-content link");if(filterRequestCount>0){requestsAnchor.textContent=WebInspector.UIString("View %d request%s in Network Panel",filterRequestCount,(filterRequestCount>1?"s":""));}else{requestsAnchor.textContent=WebInspector.UIString("View requests in Network Panel");}
requestsAnchor.href="";requestsAnchor.addEventListener("click",networkFilterFn);},__proto__:WebInspector.VBox.prototype}
WebInspector.SecurityOriginView=function(panel,origin,originState)
{this._panel=panel;WebInspector.VBox.call(this);this.setMinimumSize(200,100);this.element.classList.add("security-origin-view");this.registerRequiredCSS("security/originView.css");this.registerRequiredCSS("security/lockIcon.css");var titleSection=this.element.createChild("div","origin-view-section title-section");titleSection.createChild("div","origin-view-title").textContent=WebInspector.UIString("Origin");var originDisplay=titleSection.createChild("div","origin-display");this._originLockIcon=originDisplay.createChild("span","security-property");this._originLockIcon.classList.add("security-property-"+originState.securityState);originDisplay.createChild("span","origin").textContent=origin;if(originState.securityDetails){var connectionSection=this.element.createChild("div","origin-view-section");connectionSection.createChild("div","origin-view-section-title").textContent=WebInspector.UIString("Connection");var table=new WebInspector.SecurityDetailsTable();connectionSection.appendChild(table.element());table.addRow("Protocol",originState.securityDetails.protocol);table.addRow("Key Exchange",originState.securityDetails.keyExchange);table.addRow("Cipher Suite",originState.securityDetails.cipher+(originState.securityDetails.mac?" with "+originState.securityDetails.mac:""));var certificateSection=this.element.createChild("div","origin-view-section");certificateSection.createChild("div","origin-view-section-title").textContent=WebInspector.UIString("Certificate");function displayCertificateDetails(certificateDetails)
{var sanDiv=this._createSanDiv(certificateDetails.subject);var validFromString=new Date(1000*certificateDetails.validFrom).toUTCString();var validUntilString=new Date(1000*certificateDetails.validTo).toUTCString();var table=new WebInspector.SecurityDetailsTable();certificateSection.appendChild(table.element());table.addRow("Subject",certificateDetails.subject.name);table.addRow("SAN",sanDiv);table.addRow("Valid From",validFromString);table.addRow("Valid Until",validUntilString);table.addRow("Issuer",certificateDetails.issuer);table.addRow("",WebInspector.SecurityPanel.createCertificateViewerButton(WebInspector.UIString("Open full certificate details"),originState.securityDetails.certificateId));}
function displayCertificateDetailsUnavailable()
{certificateSection.createChild("div").textContent=WebInspector.UIString("Certificate details unavailable.");}
originState.certificateDetailsPromise.then(displayCertificateDetails.bind(this),displayCertificateDetailsUnavailable);var noteSection=this.element.createChild("div","origin-view-section");noteSection.createChild("div","origin-view-section-title").textContent=WebInspector.UIString("Development Note");noteSection.createChild("div").textContent=WebInspector.UIString("At the moment, this view only shows security details from the first connection made to %s",origin);}else{var notSecureSection=this.element.createChild("div","origin-view-section");notSecureSection.createChild("div","origin-view-section-title").textContent=WebInspector.UIString("Not Secure");notSecureSection.createChild("div").textContent=WebInspector.UIString("Your connection to this origin is not secure.");}}
WebInspector.SecurityOriginView.prototype={_createSanDiv:function(certificateSubject)
{var sanDiv=createElement("div");var sanList=certificateSubject.sanDnsNames.concat(certificateSubject.sanIpAddresses);if(sanList.length===0){sanDiv.textContent=WebInspector.UIString("(N/A)");sanDiv.classList.add("empty-san");}else{var truncatedNumToShow=2;var listIsTruncated=sanList.length>truncatedNumToShow;for(var i=0;i<sanList.length;i++){var span=sanDiv.createChild("span","san-entry");span.textContent=sanList[i];if(listIsTruncated&&i>=truncatedNumToShow)
span.classList.add("truncated-entry");}
if(listIsTruncated){var truncatedSANToggle=sanDiv.createChild("div","link");truncatedSANToggle.href="";function toggleSANTruncation()
{if(sanDiv.classList.contains("truncated-san")){sanDiv.classList.remove("truncated-san")
truncatedSANToggle.textContent=WebInspector.UIString("Show less");}else{sanDiv.classList.add("truncated-san");truncatedSANToggle.textContent=WebInspector.UIString("Show more (%d total)",sanList.length);}}
truncatedSANToggle.addEventListener("click",toggleSANTruncation,false);toggleSANTruncation();}}
return sanDiv;},setSecurityState:function(newSecurityState)
{for(var className of Array.prototype.slice.call(this._originLockIcon.classList)){if(className.startsWith("security-property-"))
this._originLockIcon.classList.remove(className);}
this._originLockIcon.classList.add("security-property-"+newSecurityState);},__proto__:WebInspector.VBox.prototype}
WebInspector.SecurityDetailsTable=function()
{this._element=createElement("table");this._element.classList.add("details-table");}
WebInspector.SecurityDetailsTable.prototype={element:function()
{return this._element;},addRow:function(key,value)
{var row=this._element.createChild("div","details-table-row");row.createChild("div").textContent=key;var valueDiv=row.createChild("div");if(typeof value==="string"){valueDiv.textContent=value;}else{valueDiv.appendChild(value);}}};Runtime.cachedResources["security/lockIcon.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.lock-icon,\n.security-property {\n    background-size: cover;\n    height: 16px;\n    width: 16px;\n}\n\n.lock-icon-unknown {\n    background-image: url(Images/securityStateNeutral.svg);\n}\n\n.lock-icon-neutral {\n    background-image: url(Images/securityStateNeutral.svg);\n}\n\n.lock-icon-insecure {\n    background-image: url(Images/securityStateInsecure.svg);\n}\n\n.lock-icon-secure {\n    background-image: url(Images/securityStateSecure.svg);\n}\n\n.security-property-insecure {\n    background-image: url(Images/securityPropertyInsecure.svg);\n}\n\n.security-property-neutral {\n    background-image: url(Images/securityPropertyWarning.svg);\n}\n\n.security-property-warning {\n    background-image: url(Images/securityPropertyWarning.svg);\n}\n\n.security-property-secure {\n    background-image: url(Images/securityPropertySecure.svg);\n}\n\n.security-property-info {\n    background-image: url(Images/securityPropertyInfo.svg);\n}\n\n/*# sourceURL=security/lockIcon.css */";Runtime.cachedResources["security/mainView.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.security-main-view {\n    -webkit-user-select: text;\n    overflow-x: hidden;\n    overflow-y: auto;\n    background-color: #f9f9f9;\n}\n\n.security-main-view > div {\n    flex-shrink: 0;\n}\n\n.security-summary {\n    background-color: #fff;\n}\n\n.security-summary-section-title {\n    font-size: 14px;\n    margin: 12px 24px;\n}\n\n.lock-spectrum {\n    min-width: 180px;\n    max-width: 240px;\n    margin: 6px 12px;\n    display: flex;\n    align-items: center;\n}\n\n.security-summary .lock-icon {\n    flex: none;\n    width: 32px;\n    height: 32px;\n    margin: 0 12px;\n    background-position: center center;\n\n    /* Defaults for dynamic properties. */\n    opacity: 0.5;\n}\n\n/* Shrink the margin for the page lock icon. */\n.security-summary .lock-icon-neutral {\n    margin: 0 6px;\n}\n\n.security-summary-secure .lock-icon-secure,\n.security-summary-neutral .lock-icon-neutral,\n.security-summary-insecure .lock-icon-insecure {\n    opacity: 1;\n}\n\n.security-summary-lock-spacer {\n    flex: 1 1 auto;\n    height: 1px;\n    background: rgb(217, 217, 217);\n}\n\n.triangle-pointer-container {\n    /* Let (lock width) = (horizonal width of 1 lock icon, including both margins) */\n    /* Horizontal margin is (lock width)/2 + (lock-spectrum horizontal margin) */\n    margin: 8px 40px 0px;\n    /* Width is (lock spectrum width) - (lock width) */\n    min-width: 124px;\n    max-width: 184px;\n}\n\n.triangle-pointer-wrapper {\n    /* Defaults for dynamic properties. */\n    transform: translateX(50%);\n    transition: transform 0.3s;\n}\n\n.triangle-pointer {\n    width:  12px;\n    height:  12px;\n    margin-bottom: -6px;\n    margin-left: -6px;\n    transform: rotate(-45deg);\n    border-style: solid;\n    border-width: 1px 1px 0 0;\n\n    /* Defaults for dynamic properties. */\n    background: rgb(243, 243, 243);\n    border-color: rgb(217, 217, 217);\n}\n\n.security-summary-secure .triangle-pointer-wrapper {\n    transform: translateX(0%);\n}\n\n.security-summary-neutral .triangle-pointer-wrapper {\n    transform: translateX(50%);\n}\n\n.security-summary-insecure .triangle-pointer-wrapper {\n    transform: translateX(100%);\n}\n\n.security-summary-text {\n    padding: 12px 24px;\n    border-style: solid;\n    border-width: 1px 0;\n\n    /* Defaults for dynamic properties. */\n    background: rgb(243, 243, 243);\n    border-color: rgb(217, 217, 217);\n    color: rgb(127, 127, 127);\n}\n\n.security-summary-secure .triangle-pointer,\n.security-summary-secure .security-summary-text {\n    background: rgb(243, 252, 244);\n    border-color: rgb(137, 222, 144);\n    color: rgb(42, 194, 57);\n}\n\n.security-summary-neutral .triangle-pointer,\n.security-summary-neutral .security-summary-text {\n    background: rgb(255, 251, 243);\n    border-color: rgb(253, 214, 129);\n    color: rgb(253, 177, 48);\n}\n\n.security-summary-insecure .triangle-pointer,\n.security-summary-insecure .security-summary-text {\n    background: rgb(253, 245, 245);\n    border-color: rgb(243, 157, 151);\n    color: rgb(216, 70, 60);\n}\n\n.security-explanation {\n    padding: 12px;\n    border-bottom: 1px solid rgb(230, 230, 230);\n    background-color: #fff;\n\n    display: flex;\n    white-space: nowrap;\n}\n\n.security-explanation-text {\n    flex: auto;\n    white-space: normal;\n}\n\n.security-explanation-info {\n    border-bottom: none;\n    background-color: transparent;\n}\n\n.security-certificate-button {\n    margin-top: 8px;\n}\n\n.security-explanation .security-property {\n    flex: none;\n    width: 18px;\n    height: 18px;\n    margin-left: 10px;\n    margin-right: 18px;\n}\n\n.security-explanation-title {\n    color: rgb(90, 90, 90);\n    margin-top: 1px;\n    margin-bottom: 8px;\n}\n\n.security-explanation-neutral .security-section-title,\n.security-explanation-warning .security-section-title\n{\n    color: rgb(253, 177, 48);\n    font-weight: bold;\n}\n.security-explanation-insecure .security-section-title\n{\n    color: rgb(216, 71, 60);\n    font-weight: bold;\n}\n\n.security-mixed-content {\n    margin-top: 8px;\n}\n\n/*# sourceURL=security/mainView.css */";Runtime.cachedResources["security/originView.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.security-origin-view {\n    overflow-x: hidden;\n    overflow-y: scroll;\n    display: block;\n    -webkit-user-select: text;\n}\n\n.security-origin-view .origin-view-section {\n    padding: 0.5em 1.5em 1.5em;\n    border-bottom: 1px solid rgb(230, 230, 230);\n}\n\n.security-origin-view .title-section {\n    padding-bottom: 1.5em;\n}\n\n.security-origin-view .origin-display .security-property {\n    margin: -1px 2px 0px 0px;\n    display: inline-block;\n    vertical-align: middle;\n}\n\n.security-origin-view .origin-view-title {\n    font-size: 1.25em;\n    margin-top: 0.5em;\n    margin-bottom: 0.25em;\n}\n\n.security-origin-view .origin-view-section-title {\n    font-weight: bold;\n    font-size: 1em;\n    margin-top: 0.5em;\n    margin-bottom: 0.25em;\n}\n\n.security-origin-view .details-table-row {\n    display: flex;\n    white-space: nowrap;\n    overflow: hidden;\n    margin-top: 6px;\n}\n\n.security-origin-view .details-table-row > div {\n    align-items: flex-start;\n}\n\n.security-origin-view .details-table-row > div:first-child {\n    color: rgb(140, 140, 140);\n    width: 7em;\n    margin-right: 1em;\n    flex: none;\n    display: flex;\n    justify-content: flex-end;\n}\n.security-origin-view .details-table-row > div:nth-child(2) {\n    flex: auto;\n    white-space: normal;\n}\n\n.security-origin-view .details-table .empty-san {\n    color: rgb(140, 140, 140);\n}\n\n.security-origin-view .details-table .san-entry {\n    display: block;\n}\n\n.security-origin-view .truncated-san .truncated-entry {\n    display: none;\n}\n\n.security-certificate-button {\n    margin-top: 4px;\n}\n\n/*# sourceURL=security/originView.css */";Runtime.cachedResources["security/sidebar.css"]="/* Copyright (c) 2015 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.tree-outline {\n    padding: 0;\n}\n\n.tree-outline li.selected .lock-icon-neutral {\n    background-image: none;\n    background-color: #5a5a5a;\n    -webkit-mask-image: url(Images/securityStateNeutral.svg);\n    -webkit-mask-size: cover;\n}\n\n.tree-outline:focus li.selected .lock-icon-neutral {\n    background-color: #fff;\n}\n\n.tree-outline .security-main-view-sidebar-tree-item {\n    border-bottom: 1px solid rgb(230, 230, 230);\n    padding-top: 0;\n}\n\n.tree-outline .security-main-view-sidebar-tree-item .icon,\n.tree-outline .security-main-view-sidebar-tree-item .titles {\n    margin-top: 1.5em;\n    margin-bottom: 1.5em;\n}\n\n.tree-outline .security-sidebar-origins {\n    padding: 1px 8px 6px 8px;\n    margin-top: 1em;\n    margin-bottom: 0.5em;\n    color: rgb(90, 90, 90);\n}\n.tree-outline ol {\n    padding-left: 0;\n}\n\n.tree-outline li::before {\n    content: none;\n}\n\n.tree-outline .security-main-view-sidebar-tree-item,\n.tree-outline .security-sidebar-origins,\n.tree-outline .sidebar-tree-section + .children > .sidebar-tree-item {\n    padding-left: 16px;\n}\n\n.tree-outline .sidebar-tree-item .lock-icon,\n.tree-outline .sidebar-tree-item .security-property {\n    float: left;\n    margin-right: 2px;\n}\n/*# sourceURL=security/sidebar.css */";